$FP_NONE = 0;
$FP_WALK = 1;
$FP_BUILD = 2;
$FP_ALL = 3;

/********************* BASE DATABLOCK OBJECT TYPES ***********************/

datablock CCmpPropData(BasePropData)
{
   // default prop settings
   initGoldMin = 0;
};

/********************* BASE DATABLOCK OBJECT TYPES ***********************/

// ------------- FOREST PROPS ------------------

// GOLD VEIN
datablock CCmpPropData(goldveinData)
{
   // random generation of resource pools on initialization
   initGold = true;
   initGoldMin = 4000;
   initGoldMax = 4500;
};

datablock SLGameObjData(goldvein)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";
   addCmpData = goldveinData;

   shapeFile = "~/data/shapes/props/forestProps/goldvein.dts";
   
   //footprint
	footprintSize = "8 8";
	footprintSetRow = "0 3 3 3 3 3 3 3 3";
	footprintSetRow = "1 3 0 0 0 0 0 0 3";
	footprintSetRow = "2 3 0 0 0 0 0 0 3";
	footprintSetRow = "3 3 0 0 0 0 0 0 3";
	footprintSetRow = "4 3 0 0 0 0 0 0 3";
	footprintSetRow = "5 3 0 0 0 0 0 0 3";
	footprintSetRow = "6 3 0 0 0 0 0 0 3";
	footprintSetRow = "7 3 3 3 3 3 3 3 3";
	footprintCenter = "4 4";
	
	//effects
	idleEffectSpecial = true;
	
	addGameEffect = "special goldsparkleEffectronData 0 2 1.2 " @ $Detail::Medium;
	addGameEffect = "special goldsparkleEffectronData 0.7 -0.3 1.7 " @ $Detail::Low;
	
	receiveLMLighting = false;
	canDamage = false;
};

// GOLD VEIN SMALL
datablock CCmpPropData(goldveinsmData)
{
   // random generation of resource pools on initialization
   initGold = true;
   initGoldMin = 100;
   initGoldMax = 125;
};

datablock CCmpPropData(appletreeData)
{
   initWood = true;
   initWoodMin = 120;
   initWoodMax = 140;
};

// Apple Tree
exec("~/data/shapes/props/forestProps/appletree.cs");
datablock SLGameObjData(appletree)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   addCmpData = appletreeData;
   
   highlight = 1; 

   shapeFile = "~/data/shapes/props/forestProps/appletree.dts";
   
   //footprint
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 0 0 1 1 1";
	footprintSetRow = "4 1 1 1 0 0 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";
	
	//Hot spots
   addHotSpot = "0 4 275";
   addHotSpot = "7 3 97";
	addHotSpot = "4 7 175";
	staticHotSpots = true;
	
	// shadow for the object
	shadowDecal = appleShadowDecal;
	shadowScale = 4.5;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	receiveLMLighting = false;

	maxHealth = 50;
	canDamage = true;
	selectionIcon = true;
   
   //Effects
   addGameEffect = "timber leafEffectronData 0 0 6.5 " @ $Detail::Medium;
   
	deathEffectTimber = true;
	deathAnimation = "fall";      // prop's dying animation
   deathProp = "treestump";      // new prop that replaces old prop
   deathSound = "audio_treefall";// prop's dying sound
   deathWait = 5;
};

datablock CCmpPropData(PineTreeData)
{
   // random generation of resource pools on initialization
   initWood = true;
   initWoodMin = 125;
   initWoodMax = 150;
};

exec("~/data/shapes/props/forestProps/furtree.cs");
datablock SLGameObjData(PineTree)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   addCmpData = PineTreeData;
   
   highlight = 1;

   shapeFile = "~/data/shapes/props/forestProps/furtree.dts";
   
   //footprint
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 0 0 1 1 1";
	footprintSetRow = "4 1 1 1 0 0 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";

	// shadow for the object
	shadowDecal = PineShadowDecal;
	shadowScale = 5.3;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	receiveLMLighting = false;
	
	selectionIcon = true;

	//Hot spots
   addHotSpot = "0 4 275";
   addHotSpot = "7 3 97";
	addHotSpot = "4 7 175";
	staticHotSpots = true;
   
   //Effects
   addGameEffect = "timber pineEffectronData 0 0 7.5 " @ $Detail::Medium;
   
	deathEffectTimber = true;
	deathAnimation = "fall";      // prop's dying animation
   deathProp = "treestump";      // new prop that replaces old prop
   deathSound = "audio_treefall";// prop's dying sound
   deathWait = 5;                // time to wait before fade starts
};
exec("~/data/shapes/props/forestProps/oaktree.cs");
datablock SLGameObjData(oaktree)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = PineTreeData;
   
   highlight = 1;

   shapeFile = "~/data/shapes/props/forestProps/oaktree.dts";
   
   //footprint
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 0 0 1 1 1";
	footprintSetRow = "4 1 1 1 0 0 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";
	
	// shadow for the object
	shadowDecal = oakShadowDecal;
	shadowScale = 4.6;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	receiveLMLighting = false;
	
	selectionIcon = true;
	
	//Hot spots
   addHotSpot = "0 4 275";
   addHotSpot = "7 3 97";
	addHotSpot = "4 7 175";
	staticHotSpots = true;
	
	//Effects
   addGameEffect = "timber leafEffectronData 0 0 6.5 " @ $Detail::Medium;
   
	deathEffectTimber = true;
	deathAnimation = "fall";      // prop's dying animation
   deathProp = "treestump";      // new prop that replaces old prop
   deathSound = "audio_treefall";// prop's dying sound
   deathWait = 5;
};
//Dead Oak Tree
exec("~/data/shapes/props/desertProps/deadoaktree.cs");
datablock SLGameObjData(deadoaktree)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = PineTreeData;
   
   highlight = 1;

   shapeFile = "~/data/shapes/props/desertProps/deadoaktree.dts";
   
   //footprint
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 0 0 1 1 1";
	footprintSetRow = "4 1 1 1 0 0 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";
	
	// shadow for the object
	shadowDecal = deadoakShadowDecal;
	shadowScale = 4.2;
	shadowOffsetStatic = "-0.1 -.1";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 180;
	shadowAngleDynamic = true;
	
	receiveLMLighting = false;
	
	selectionIcon = true;
	
	//Hot spots
   addHotSpot = "0 4 275";
   addHotSpot = "7 3 97";
	addHotSpot = "4 7 175";
	staticHotSpots = true;
	
	//Effects
   //addGameEffect = "timber leafEffectronData 0 0 6.5 " @ $Detail::Medium;
   
	deathEffectTimber = true;
	deathAnimation = "fall";      // prop's dying animation
   deathProp = "treestump";      // new prop that replaces old prop
   deathSound = "audio_treefall";// prop's dying sound
   deathWait = 5;
};

datablock SLGameObjData(Chicken)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/chicken.dts";
   
   // shadow for the object

	receiveLMLighting = false;
	
	detailLevel = $Detail::Medium;
};

datablock SLGameObjData(DestinationFlagData)
{
   snapGrid  = $SnapGrid::Detail;
   shapeFile = "~/data/shapes/props/destinationflag.dts";
    
   receiveLMLighting = false;
   
   //effects
	idleEffectSpecial = true;
};

datablock SLGameObjData(Dynamite)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "assets/data/shapes/props/townProps/keg.dts";

	receiveLMLighting = false;
	
	dmgStartRadius = 5;
	dmgStartPower = 150;
	dmgEndRadius = 15;
	dmgEndPower = 5;
	dmgTime = 3;
	
	//footprint
	footprintSize = "2 2";
	footprintSetRow = "0 1 1";
	footprintSetRow = "1 1 1";
	footprintCenter = "1 1";
	
	deathEffectDynamite = "true";
	deathWait = 5;
	
	//effects
	addGameEffect = "dynamite explosionEffectronData 0 0 1.8 " @ $Detail::Low;
	addGameEffect = "dynamite whitepuffEffectronData 0 0 0.8 " @ $Detail::Medium;
	
};

datablock SLGameObjData(Flower)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/flower.dts";

	//footprint
	footprintSize = "1 1";
	footprintSetRow = "0 3";
	footprintCenter = "0.5 0.5";
	receiveLMLighting = false;
	
	maxHealth = 20;
	canDamage = true;
	
	detailLevel = $Detail::High;
};
// Randomly sets a skin texture when flower is placed.a
function Flower::onAdd(%this,%obj)
{
  %texturestring = "base yellow pink purple white";
  %randomnum = mAbs(getRandom(0,4));
  %randomtexture = getWord(%texturestring,%randomnum);
  %obj.setSkinName(%randomtexture);
}

datablock SLGameObjData(Tombstone)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/tombstone.dts";
   
   //footprint
	footprintSize = "2 4";
	footprintSetRow = "0 1 1";
	footprintSetRow = "1 1 1";
	footprintSetRow = "2 1 1";
	footprintSetRow = "3 1 1";
	footprintCenter = "1 2";
   
	// shadow for the object
	receiveLMLighting = false;
};

datablock SLGameObjData(Pig)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/pig.dts";
   
	receiveLMLighting = false;
	
};

datablock SLGameObjData(Cattail)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/cattail.dts";
   
   // shadow for the object
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "1 1";
	footprintSetRow = "0 2";
	footprintCenter = "0.5 0.5";
	
	buildOver = true;
	
	detailLevel = $Detail::High;
};

datablock SLGameObjData(fern)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/props/forestProps/fern.dts";
   
   // shadow for the object
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "1 1";
	footprintSetRow = "0 2";
	footprintCenter = "0.5 0.5";
	
	buildOver = true;
	
	maxHealth = 50;
	canDamage = true;
	
	detailLevel = $Detail::High;
};

datablock SLGameObjData(Forestfern)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/forestfern.dts";
   
   // shadow for the object
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "1 1";
	footprintSetRow = "0 2";
	footprintCenter = "0.5 0.5";
	
	buildOver = true;
	maxHealth = 50;
	canDamage = true;
	
	detailLevel = $Detail::Medium;
};

datablock SLGameObjData(Largerock)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;

   shapeFile = "~/data/shapes/props/forestProps/largerock.dts";
   
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 0 0 1";
	footprintSetRow = "5 1 0 0 0 0 0 0 1";
	footprintSetRow = "6 1 0 0 0 0 0 0 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";
	
	maxHealth = 100;
	canDamage = true;
	
	//Effects
   addGameEffect = "timber rockexplosionEffectronData 0 0 4 " @ $Detail::High;
   
	deathEffectTimber = true;

};

datablock SLGameObjData(cave)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/props/desertProps/cave.dts";
   
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 0 0 1";
	footprintSetRow = "5 1 0 0 0 0 0 0 1";
	footprintSetRow = "6 1 0 1 1 1 1 0 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";
	
	maxHealth = 9000;
	canDamage = false;
};

datablock SLGameObjData(Minerockcover)
{
   snapGrid = $SnapGrid::Terrain;

   shapeFile = "~/data/shapes/props/forestProps/minerockcover.dts";
   
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "8 8";
	footprintSetRow = "0 0 0 0 0 0 0 0 0";
	footprintSetRow = "1 0 0 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0 0 0";
	footprintSetRow = "4 0 0 0 0 0 0 0 0";
	footprintSetRow = "5 0 0 0 0 0 0 0 0";
	footprintSetRow = "6 0 0 0 0 0 0 0 0";
	footprintSetRow = "7 0 0 0 0 0 0 0 0";
	footprintCenter = "4 4";
	
	portraitOffset = "0 0 0";
	portraitRotation = "0";
	portraitHeight = "3";
	portraitZoom = "95";
	portraitAngle = "15";
	portraitFOV = "4";
	
	maxHealth = 90;
	canDamage = true;
	
	//Effects
   //addGameEffect = "timber leafEffectronData 0 0 6.5 " @ $Detail::Medium;
};

function Tornado::onAdd(%this,%obj)
{
  %obj.playThread(0, "ambient");
}
datablock SLGameObjData(Tornado)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/effects/tornado.dts";
   
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "4 4";
	footprintSetRow = "0 3 3 3 3";
	footprintSetRow = "1 3 3 3 3";
	footprintSetRow = "2 3 3 3 3";
	footprintSetRow = "3 3 3 3 3";
	footprintCenter = "2 2";
	
	//Effects
	addGameEffect = "tornado tornadoEffectronData 0 4 28 " @ $Detail::High;
	addGameEffect = "tornado tornadodustEffectronData 0 0 1.2 " @ $Detail::Medium;
};

datablock SLGameObjData(smrock)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/smrock.dts";
   
   // shadow for the object
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "2 2";
	footprintSetRow = "0 0 0";
	footprintSetRow = "1 0 0";
	footprintCenter = "1 1";
	
	maxHealth = 50;
	canDamage = true;
	
	buildOver = true;
	
	detailLevel = $Detail::Medium;
};

datablock SLGameObjData(rocklog)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/rocklog.dts";
   
   // shadow for the object
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "4 4";
	footprintSetRow = "0 1 1 1 1";
	footprintSetRow = "1 1 0 0 1";
	footprintSetRow = "2 1 0 0 1";
	footprintSetRow = "3 1 1 1 1";
	footprintCenter = "2 2";
	
	maxHealth = 75;
	canDamage = true;
};

datablock SLGameObjData(sapling)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/sapling.dts";
   
   // shadow for the object
	shadowDecal = SaplingShadowDecal;
	shadowScale = 2.8;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//footprint
	footprintSize = "2 2";
	footprintSetRow = "0 1 1";
	footprintSetRow = "0 1 1";
	footprintCenter = "1 1";
	
	receiveLMLighting = false;
	
	detailLevel = $Detail::Medium;
	
	maxHealth = 50;
	canDamage = true;
	
	//Effects
   addGameEffect = "timber leafEffectronData 0 0 5 " @ $Detail::Medium;
};

datablock SLGameObjData(treestump)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/treestump.dts";

   // shadow for the object
	shadowAngleDynamic = true;
	
	//footprint
	footprintSize = "2 2";
	footprintSetRow = "0 2 2";
	footprintSetRow = "1 2 2";
	footprintCenter = "1 1";
	
	buildOver = true;
	
	maxHealth = 20;
	canDamage = true;
	
	//Effects
   //addGameEffect = "timber leafEffectronData 0 0 6.5 " @ $Detail::Medium;
   
	deathEffectTimber = true;
	deathAnimation = "fall";      // prop's dying animation
   deathProp = "treestump";      // new prop that replaces old prop
   deathWait = 5;
	
};
datablock SLGameObjData(joshuastump)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;

   shapeFile = "~/data/shapes/props/desertProps/joshuastump.dts";

   // shadow for the object
	shadowAngleDynamic = true;
	
	//footprint
	footprintSize = "2 2";
	footprintSetRow = "0 2 2";
	footprintSetRow = "1 2 2";
	footprintCenter = "1 1";
	
	buildOver = true;
	
	detailLevel = $Detail::Medium;
	
	maxHealth = 20;
	canDamage = true;
};
datablock SLGameObjData(oldstump)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/props/forestProps/largestump.dts";

   // shadow for the object
	shadowAngleDynamic = true;
	
	//footprint
	footprintSize = "2 2";
	footprintSetRow = "0 1 1";
	footprintSetRow = "1 1 1";
	footprintCenter = "1 1";
	
	detailLevel = $Detail::Medium;
	
	receiveLMLighting = false;
	maxHealth = 30;
	canDamage = true;

};

datablock SLGameObjData(pumpkin)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/pumpkin.dts";

   // shadow for the objec
	receiveLMLighting = false;
	buildOver = true;
	
};

datablock SLGameObjData(corn)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/corn.dts";

   // shadow for the object
	receiveLMLighting = false;
	buildOver = true;
	
};

datablock SLGameObjData(wheat)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/forestProps/wheat.dts";
   
   // shadow for the object
	receiveLMLighting = false;
	buildOver = true;
	
	detailLevel = $Detail::low;
};
// ------------ DESERT PROPS ---------------

datablock SLGameObjData(drygrass)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/desertProps/drygrass.dts";
   
   //footprint
	footprintSize = "1 1";
	footprintSetRow = "0 3 ";
	footprintCenter = "0.5 0.5";
   
   // shadow for the object
	receiveLMLighting = false;
	buildOver = true;
	
	maxHealth = 25;
	canDamage = true;
	
	detailLevel = $Detail::High;
};

datablock SLGameObjData(Pearcactus)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/desertProps/pearcactus.dts";
   
   footprintSize = "1 1";
	footprintSetRow = "0 2";
	footprintCenter = "0.5 0.5";
   
   // shadow for the object
	receiveLMLighting = false;
	buildOver = true;
	
	maxHealth = 25;
	canDamage = true;
	
	detailLevel = $Detail::Medium;
};

datablock SLGameObjData(cowbones)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/desertProps/cowbones.dts";
   
   footprintSize = "2 1";
	footprintSetRow = "0 2 2";
	footprintCenter = "1 0.5";
   
	buildOver = true;
	
	maxHealth = 25;
	canDamage = true;

};

datablock SLGameObjData(Cactus1)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/desertProps/cactus1.dts";
   
   footprintSize = "1 1";
	footprintSetRow = "0 2";
	footprintCenter = "0.5 0.5";
   
   buildOver = true;
   // shadow for the object
	receiveLMLighting = false;
	
	maxHealth = 25;
	canDamage = true;
	
	detailLevel = $Detail::medium;
};

datablock SLGameObjData(Cactus2)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/props/desertProps/cactus2.dts";
   
   footprintSize = "1 1";
	footprintSetRow = "0 2";
	footprintCenter = "0.5 0.5";
   
   buildOver = true;

   // shadow for the object
	receiveLMLighting = false;
	
	maxHealth = 25;
	canDamage = true;
	
	detailLevel = $Detail::Medium;
};

datablock SLGameObjData(Cactus3)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;

   shapeFile = "~/data/shapes/props/desertProps/cactus3.dts";
   
   footprintSize = "1 1";
	footprintSetRow = "0 2";
	footprintCenter = "0.5 0.5";
   
   buildOver = true;
   
	receiveLMLighting = false;
	
	detailLevel = $Detail::Medium;
	
	maxHealth = 25;
	canDamage = true;
};

datablock SLGameObjData(whiterocks)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/desertProps/whiterocks.dts";

   // shadow for the object
	
	footprintSize = "4 4";
	footprintSetRow = "0 0 0 0 0 ";
	footprintSetRow = "1 0 0 0 0 ";
	footprintSetRow = "2 0 0 0 0 ";
	footprintSetRow = "3 0 0 0 0 ";
	footprintCenter = "2 2";
	
	maxHealth = 100;
	canDamage = true;

};
exec("~/data/shapes/props/desertProps/deserttree.cs");
datablock SLGameObjData(Joshuatree)
{
   snapGrid = $SnapGrid::Detail;
   
   addCmpData = PineTreeData;
	shapeFile = "~/data/shapes/props/desertProps/deserttree.dts";
   
	//footprint
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 0 0 1 1 1";
	footprintSetRow = "4 1 1 1 0 0 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";

   //Hot spots
   addHotSpot = "0 4 275";
   addHotSpot = "7 3 97";
	addHotSpot = "4 7 175";
	staticHotSpots = true;
   
	// shadow for the object
	shadowDecal = JoshuaShadowDecal;
	shadowScale = "6";
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-1 0.2";
	shadowAngleStatic = 180;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	selectionIcon = true;
	
	deathEffectTimber = true;
	deathAnimation = "fall";    // prop's dying animation
   deathProp = "joshuastump";  // new prop that replaces old prop
   deathSound = "audio_treefall";// prop's dying sound
   deathWait = 5;
};

datablock SLGameObjData(desertrockarch)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/desertProps/desertrockarch.dts";
   
   //footprint
	footprintSize = "16 8";
	footprintSetRow = "0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintSetRow = "1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintSetRow = "4 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintSetRow = "5 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintSetRow = "6 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintSetRow = "7 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0";
	footprintCenter = "8 4";

	// shadow for the object
	receiveLMLighting = true;
	
	canDamage = false;
};

datablock SLGameObjData(desertrock1)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/props/desertProps/desertrock1.dts";
   
   //footprint
	footprintSize = "6 6";
	footprintSetRow = "0 1 0 0 0 0 1";
	footprintSetRow = "1 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0";
	footprintSetRow = "4 0 0 0 0 0 0";
	footprintSetRow = "5 1 0 0 0 0 1";
	footprintCenter = "3 3";

	// shadow for the object
	receiveLMLighting = false;
	
	maxHealth = 50;
	canDamage = true;
	
	//Effects
	deathEffectTimber = true;
   addGameEffect = "timber rockexplosionEffectronData 0 0 4 " @ $Detail::Medium;
   //deathAnimation = "pickup"; // prop's dying animation
   deathFade = 3.5;

};

datablock SLGameObjData(desertrock2)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/desertProps/desertrock2.dts";
   
  //footprint
	footprintSize = "6 6";
	footprintSetRow = "0 1 0 0 0 0 1";
	footprintSetRow = "1 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0";
	footprintSetRow = "4 0 0 0 0 0 0";
	footprintSetRow = "5 1 0 0 0 0 1";
	footprintCenter = "3 3";

	// shadow for the object
	receiveLMLighting = false;
	
	maxHealth = 50;
	canDamage = true;
	
	//Effects
	deathEffectTimber = true;
   addGameEffect = "timber rockexplosionEffectronData 0 0 4 " @ $Detail::Medium;
   deathFade = 3.5;

};
datablock SLGameObjData(desertrocksm)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/desertProps/smredrocks.dts";
   
   //footprint
	footprintSize = "6 6";
	footprintSetRow = "0 1 1 1 1 1 0 1";
	footprintSetRow = "1 0 0 0 0 0 0 1";
	footprintSetRow = "2 0 0 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 0 1";
	footprintSetRow = "5 1 1 0 0 0 0 1";
	footprintCenter = "3 3";
	
	// shadow for the object
	receiveLMLighting = true;
	
	maxHealth = 50;
	canDamage = true;

};
// ------------ TOWN PROPS ---------------

// TENT
datablock SLGameObjData(Tent)
{
   snapGrid = $SnapGrid::Object;
   //addCmpData = BasePropData;

   shapeFile = "~/data/shapes/props/townProps/tent.dts";
   
	//footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 4";
	footprintSetRow = "0 0 0 0 0 0 0 0 0";
	footprintSetRow = "1 0 0 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0 0 0";
	footprintCenter = "4 2";
	
	maxHealth = 40;
	canDamage = true;

};

// fountain water
datablock StaticShapeData(fountainwaterData)
{
   shapeFile = "~/data/shapes/props/townProps/watertest.dts";
   reloadProduce = false;
};
datablock CCmpBuildingData(FountainData)
{
   
   // door offset from position
   door = "0 2 0";
	
   buildHappiness = "4 3 2";
   happinessString = "Fountain Beauty";
   
   produce = "fountainwater";
   produceType = $Resource::water;
   
   // fountainwater prop
   addProduceTime = "fountainwater 30 0 0";
   addProduceRates = "fountainwater 1";
   addProduceDatablock = "fountainwater fountainwaterData";
   addProducePoint = "fountainwater 0 0 -0.4";
   
   produceTime = 30;
   consumeWater = "1";
   
   // construction building properties
   constructionProp = "0 0 0 0.8 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 0 0.8 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 3.2;
   constructionTime = 8;
   constructionPresentStart = 2;
   constructionPresentStop = 6;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 3;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 12;
   repairGold = 9;
   repaitWood = 7;
   
   flammable = false;
   
   // housing values
   housingOffset = 0;
};

datablock SLGameObjData(Fountain)
{
   addCmpData = FountainData;
   addCmpData = BaseCmdData;
   
   goldCost = 120;
   woodCost = 90;

   healthMax = 100;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 2";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

	snapGrid = $SnapGrid::Object;

   shapeFile = "~/data/shapes/props/townProps/fountain.dts";

	//footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "6 6";
	footprintSetRow = "0 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 1";
	footprintSetRow = "5 1 1 1 1 1 1";
	footprintCenter = "3 3";
	
	portraitOffset = "0 0 6.1";
	portraitRotation = "0";
	portraitHeight = "8";
	portraitZoom = "11";
	portraitAngle = "7";
	portraitFOV = "25";
	
	//Naming
	nameKey = "fountain_name";
	
	//Effects
	addGameEffect = "produce waterEffectronData 0 0 1.9 " @ $Detail::High;
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_FTN01 m_civilian_FTN02 m_civilian_FTN03";
	fConstructSound = "f_civilian_FTN01 f_civilian_FTN02 f_civilian_FTN03";
};

datablock CCmpBuildingData(TownbellData)
{
   // door offset from position
   door = "0 2 0";

   buildHappiness = "3 2 1";
   happinessString = "Town Bell History";

   // construction building properties
   constructionProp = "0 0 0 0.8 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 3;
   constructionTime = 8;
   constructionPresentStart = 2;
   constructionPresentStop = 6;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "75 -1 base";
   damageData = "50 -2 damage";

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 2;
   destructionTime = 6;

   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 10;
   repaitWood = 5;
   
   flammable = false;
   
   // housing values
   housingOffset = 0;
};
datablock SLGameObjData(Townbell)
{
   
	addCmpData = TownbellData;
   addCmpData = BaseCmdData;

   goldCost = 110;
   woodCost = 50;
   
   healthMax = 80;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
	
	snapGrid = $SnapGrid::Object;

   shapeFile = "~/data/shapes/props/townProps/townbell.dts";

	//footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "6 4";
	footprintSetRow = "0 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 1";
	footprintSetRow = "3 1 1 1 1 1 1";
	footprintCenter = "3 2";
	
	smallMinimapIcon = true;
	
	shadowDecal = WelcomeShadowDecal;
	shadowScale = 2;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "-0 0 10";
	portraitRotation = "25";
	portraitHeight = "12.5";
	portraitZoom = "8";
	portraitAngle = "8";
	portraitFOV = "25";
	
	//Naming
	nameKey = "townbell_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_TWB01 m_civilian_TWB02 m_civilian_TWB03";
	fConstructSound = "f_civilian_TWB01 f_civilian_TWB02";
};
datablock CCmpBuildingData(WesternwindmillData)
{
   // door offset from position
   door = "0 4 0";

   // construction building properties
   constructionProp = "0 0 0 0.8 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 3.5;
   constructionTime = 10;
   constructionPresentStart = 2;
   constructionPresentStop = 8;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 base";

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "2 0 0 0.6 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 4.5;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 6;
   repaitWood = 8;
   
   // housing values
   housingOffset = 0;
};
datablock SLGameObjData(Windmill)
{
   snapGrid = $SnapGrid::Object;
   addCmpData = WesternwindmillData;
   addCmpData = BaseCmdData;

   // health
   healthMax = 120;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   shapeFile = "~/data/shapes/props/townProps/westwindmill.dts";
   
   // resource requirements to build object
   goldCost = 80;
   woodCost = 130;

	//footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 0 0 0 0 1 1";
	footprintSetRow = "2 1 0 0 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 0 0 1";
	footprintSetRow = "5 1 0 0 0 0 0 0 1";
	footprintSetRow = "6 1 1 0 0 0 0 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";

	smallMinimapIcon = true;
	
	// shadow for the object
	shadowDecal = WatertowerShadowDecal;
	shadowScale = 3.2;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0.3 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 1";
	portraitRotation = "25";
	portraitHeight = "8";
	portraitZoom = "25";
	portraitAngle = "4";
	portraitFOV = "30";
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 2;
   deathProp = "woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 1 1";  // the location to place the death props
	
	//Effects
   addGameEffect = "construct constructsmEffectronData 0 0 1.5 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 1.4 1.8 3 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 1.4 1.8 3.9 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData -0.9 1.3 8 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -.09 1.3 8.6 " @ $Detail::High;


   //Naming
	nameKey = "windmill_name";
};

// OLD CABIN
datablock CCmpBuildingData(OldCabinData)
{
   // door position
   door = "1 5 0";

	// health and damage states for the building
   damageData = "100 0 base";

   // destruction building properties
   destructionProp = "4 4 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "-4 -3 0 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 0 75 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 6;
   destructionTime = 10;
};
// Old Cabin Object
datablock SLGameObjData(OldCabin)
{
   snapGrid = $SnapGrid::Object;
   addCmpData = OldCabinData;
   //addCmpData = BasePropData;

   shapeFile = "~/data/shapes/props/townProps/oldcabin.dts";

	// health
   healthMax = 120;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 0 0 0 0 0 0 0 0";
	footprintSetRow = "1 0 0 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0 0 0";
	footprintSetRow = "4 0 0 0 0 0 0 0 0";
	footprintSetRow = "5 0 0 0 0 0 0 0 0";
	footprintSetRow = "6 0 0 0 0 0 0 0 0";
	footprintSetRow = "7 0 0 0 0 0 0 0 0";
	footprintCenter = "4 4";
	
	portraitOffset = "0 0 0";
	portraitRotation = "-12";
	portraitHeight = "5";
	portraitZoom = "115";
	portraitAngle = "4";
	portraitFOV = "5";
	
	canDamage = true;

   // shadow for the object
	receiveLMLighting = false;
};

datablock SLGameObjData(scarecrow)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/scarecrow.dts";
	receiveLMLighting = false;
	
};
datablock CCmpBuildingData(FlowerpotData)
{
   // door offset from position
   door = "0 1 0";

   buildHappiness = "3 2 1 1 1 1";
   happinessString = "Flower Pot Beauty";

   // construction building properties
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 2.5;
   constructionTime = 4;
   constructionPresentStart = 1;
   constructionPresentStop = 3;

   // health and damage states for the building
   damageData = "100 0 base";

   // destruction building properties
   destructionProp = "0 0 0 0.4 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 2.5;
   destructionTime = 3;
   
   // repair info
   repairTime = 2;
   repairAmount = 10;
   repairGold = 2;
   repaitWood = 2;
   
   flammable = false;

};

datablock SLGameObjData(Flowerpot)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = FlowerpotData;
   addCmpData = BaseCmdData;
   
   goldCost = 50;
   woodCost = 20;

   healthMax = 50;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   
   //footprint
   footprintGrid = $SnapGrid::Detail;
	footprintSize = "6 6";
	footprintSetRow = "0 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 0 0 1 1";
	footprintSetRow = "3 1 1 0 0 1 1";
	footprintSetRow = "4 1 1 1 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1";
	footprintCenter = "3 3";

   shapeFile = "~/data/shapes/props/townProps/largeflower.dts";
	receiveLMLighting = false;
	smallMinimapIcon = true;
	
	portraitOffset = "0 0 6";
	portraitRotation = "0";
	portraitHeight = "8";
	portraitZoom = "12";
	portraitAngle = "4";
	portraitFOV = "18";
	
	//Naming
	nameKey = "flowerpot_name";
	
	// Construction finished sounds
	constructSoundChance = "80";
	mConstructSound = "m_civilian_FPT01 m_civilian_FPT02 m_civilian_FPT03";
	fConstructSound = "f_civilian_FPT01 f_civilian_FPT02 f_civilian_FPT03";
};

datablock CCmpBuildingData(HoneypotData)
{
   // door offset from position
   door = "0 2 0";

   buildHappiness = "2 2 2";
   happinessString = "Honey Pot Flavors";
   
   produceTime = 30;
   produceFood = "2";

   // construction building properties
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 2.5;
   constructionTime = 4;
   constructionPresentStart = 1;
   constructionPresentStop = 3;

   // health and damage states for the building
   damageData = "100 0 base";

   // destruction building properties
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 2.5;
   destructionTime = 3;
   
   // repair info
   repairTime = 2;
   repairAmount = 10;
   repairGold = 2;
   repaitWood = 2;
   
   flammable = false;

};
datablock SLGameObjData(Honeypot)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = HoneypotData;
   addCmpData = BaseCmdData;
   
   goldCost = 20;
   woodCost = 5;

   healthMax = 25;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   
   //footprint
	footprintSize = "6 6";
	footprintSetRow = "0 3 1 1 1 1 3 ";
	footprintSetRow = "1 1 1 0 0 1 1 ";
	footprintSetRow = "2 1 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 1";
	footprintSetRow = "4 1 1 0 0 1 1";
	footprintSetRow = "5 3 1 1 1 1 3";
	footprintCenter = "3 3";

   shapeFile = "~/data/shapes/props/townProps/honeypot.dts";
	receiveLMLighting = false;
	smallMinimapIcon = true;
	
	portraitOffset = "0 0 6";
	portraitRotation = "0";
	portraitHeight = "8";
	portraitZoom = "12";
	portraitAngle = "4";
	portraitFOV = "18";
	
	//Naming
	nameKey = "honeypot_name";
};

datablock SLGameObjData(Firepit)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/firepit.dts";

	receiveLMLighting = false;
	
	//addEffect = DefaultEffectronData;
	
};
datablock CCmpBuildingData(StatueData)
{
   // door offset from position
   door = "0 2 0";

   buildHappiness = "5 3 2";
   happinessString = "Statue History";

   // construction building properties
   constructionProp = "0 0 0 0.8 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 3;
   constructionTime = 14;
   constructionPresentStart = 2;
   constructionPresentStop = 13;

   // health and damage states for the building
   damageData = "100 0 base";

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 3;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 12;
   repairGold = 10;
   repaitWood = 4;
   
   flammable = false;
   
   // housing values
   housingOffset = 0;
};
datablock SLGameObjData(Statue)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = StatueData;
   addCmpData = BaseCmdData;
	
	goldCost = 150;
   woodCost = 50;
   
   healthMax = 200;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   shapeFile = "~/data/shapes/props/townProps/mayorstatue.dts";
   
   //footprint
	footprintSize = "4 4";
	footprintSetRow = "0 0 0 0 0 ";
	footprintSetRow = "1 0 0 0 0 ";
	footprintSetRow = "2 0 0 0 0 ";
	footprintSetRow = "3 0 0 0 0 ";
	footprintCenter = "2 2";
	
	// shadow for the object

	receiveLMLighting = false;
	smallMinimapIcon = true;

	portraitOffset = "0 -0.5 4";
	portraitRotation = "33";
	portraitHeight = "8";
	portraitZoom = "16";
	portraitAngle = "5";
	portraitFOV = "22";
	
	//Naming
	nameKey = "statue_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_STT01 m_civilian_STT02 m_civilian_STT03";
	fConstructSound = "f_civilian_STT01 f_civilian_STT02 f_civilian_STT03";
};
// Road Sign
datablock SLGameObjData(roadsign)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/roadsign.dts";
   
   //footprint
	footprintSize = "3 3";
	footprintSetRow = "0 1 1 1";
	footprintSetRow = "1 1 0 1";
	footprintSetRow = "2 1 1 1";
	footprintCenter = "1.5 1.5";
	
	canDamage = false;
	
	// shadow for the object
	receiveLMLighting = false;
	
};
// Keg
datablock SLGameObjData(keg)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/keg.dts";

	receiveLMLighting = false;
	
	detailLevel = $Detail::medium;
};

// Welcome sign
datablock CCmpBuildingData(WelcomesignData)
{
   // door offset from position
   door = "0 1 0";

   buildHappiness = "3 1";
   happinessString = "Welcome Sign Hospitality";

   // construction building properties
   constructionProp = "0 0 0 0.8 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 3;
   constructionTime = 8;
   constructionPresentStart = 2;
   constructionPresentStop = 8;

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 5;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 12;
   repairGold = 4;
   repaitWood = 5;
   
   flammable = false;

};
datablock SLGameObjData(welcomesign)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = BaseCmdData;
   addCmpData = WelcomesignData;
   
   healthMax = 100;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   shapeFile = "~/data/shapes/props/townProps/welcomesign.dts";
   
   // resource requirements to build object
   goldCost = 50;
   woodCost = 80;
   
   //footprint
	footprintSize = "12 6";
	footprintSetRow = "0 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 0 0 1 1 1 1 0 0 1 1";
	footprintSetRow = "3 1 1 0 0 1 1 1 1 0 0 1 1";
	footprintSetRow = "4 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "6 3";

   smallMinimapIcon = true;
   
	// shadow for the object
	shadowDecal = WelcomeShadowDecal;
	shadowScale = 4.5;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;

	portraitOffset = "-.5 0 10";
	portraitRotation = "25";
	portraitHeight = "15";
	portraitZoom = "22";
	portraitAngle = "3";
	portraitFOV = "25";
	
	//Naming
	nameKey = "welcomesign_name";
	
	// Construction finished sounds
	constructSoundChance = "80";
	mConstructSound = "m_civilian_WCM01 m_civilian_WCM02 m_civilian_WCM03";
	fConstructSound = "f_civilian_WCM01 f_civilian_WCM02 f_civilian_WCM03";
};

datablock SLGameObjData(Barrel)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   objTileOffset = "0.5 0.5";
   
   shapeFile = "~/data/shapes/props/townProps/barrel.dts";
   footprintSize = "1 1";
   footprintSetRow = "0 0";
	footprintCenter = "0.5 0.5";
	
	// shadow for the object
	receiveLMLighting = false;
	
	maxHealth = 25;
	canDamage = true;
};

datablock SLGameObjData(spear)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/spear.dts";

   // shadow for the object
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "1 1";
	footprintSetRow = "0 0";

	footprintCenter = "0.5 0.5";
	
	maxHealth = 25;
	canDamage = true;   

};

datablock SLGameObjData(Box)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   objTileOffset = "0.5 0.5";

   shapeFile = "~/data/shapes/props/townProps/box.dts";
   footprintSize = "1 2";
   footprintSetRow = "0 0";
   footprintSetRow = "1 0";
	footprintCenter = "0.5 1";
	
	// shadow for the object
	receiveLMLighting = false;
	
	maxHealth = 30;
	canDamage = true;
	
	detailLevel = $Detail::medium;
};

datablock SLGameObjData(hitchpost)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   objTileOffset = "0.5 0.5";

   shapeFile = "~/data/shapes/props/townProps/hitchpost.dts";
   footprintSize = "4 1";
   footprintSetRow = "0 0 0 0 1";
	footprintCenter = "2 0.5";
	
	maxHealth = 1000;
	canDamage = false;
	
	// shadow for the object
	receiveLMLighting = false;
};
datablock SLGameObjData(cart)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   objTileOffset = "0.5 0.5";

   shapeFile = "~/data/shapes/props/townProps/cart.dts";
   footprintSize = "2 2";
   footprintSetRow = "0 0 0";
   footprintSetRow = "1 0 0";
	footprintCenter = "1 1";
	
	maxHealth = 50;
	canDamage = true;
	
	detailLevel = $Detail::low;

	// shadow for the object
	receiveLMLighting = false;
};
datablock SLGameObjData(watertrough)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/watertrough.dts";
   footprintSize = "3 1";
   footprintSetRow = "0 0 0 0";
	footprintCenter = "1.5 0.5";
	
	maxHealth = 30;
	canDamage = true;
	
	detailLevel = $Detail::Medium;

	// shadow for the object
	receiveLMLighting = false;
};
datablock SLGameObjData(fence)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/fence.dts";
   footprintSize = "6 1";
   footprintSetRow = "0 0 0 0 0 0 0";
	footprintCenter = "3 0.5";
	
	maxHealth = 30;
	canDamage = true;

	// shadow for the object
	receiveLMLighting = false;
};
datablock SLGameObjData(forestdepletsign)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/forestdepletesign.dts";
   footprintSize = "1 1";
   footprintSetRow = "0 0";
	footprintCenter = "1 1";
	
	// shadow for the object
	receiveLMLighting = false;
};

datablock SLGameObjData(gate)
{
   snapGrid = $SnapGrid::Detail;
   
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/gate.dts";
   footprintSize = "3 2";
   footprintSetRow = "0 0 0 0";
   footprintSetRow = "1 0 0 0";
	footprintCenter = "2 1";

	canDamage = false;

   // shadow for the object
   receiveLMLighting = false;  
};
datablock SLGameObjData(gatedoor)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/props/townProps/gatedoor.dts";
   footprintSize = "3 2";
   footprintSetRow = "0 0 0 0";
   footprintSetRow = "1 0 0 0";
	footprintCenter = "3 0.5";
	
	canDamage = false;

   // shadow for the object
   receiveLMLighting = false;        

};


// ------------ Construction and Destruction Props -------------

datablock SLGameObjData(constproptable)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/constructproptable.dts";
   footprintSize = "2 2";
   footprintSetRow = "0 0 0";
   footprintSetRow = "1 0 0";
	footprintCenter = "1 1";

	receiveLMLighting = false;
	
	detailLevel = $Detail::low;
};
datablock SLGameObjData(constpropbricks)
{
   snapGrid = $SnapGrid::Detail;
   
   shapeFile = "~/data/shapes/props/townProps/constructpropbricks.dts";
   footprintSize = "4 4";
   footprintSetRow = "0 0 0 0 0";
   footprintSetRow = "1 0 0 0 0";
   footprintSetRow = "2 0 0 0 0";
   footprintSetRow = "3 0 0 0 0";
	footprintCenter = "2 2";
   
   maxHealth = 30;
	canDamage = true;
	
	receiveLMLighting = false;
	
	detailLevel = $Detail::Medium;
};
datablock SLGameObjData(constproplogs)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;

   shapeFile = "~/data/shapes/props/townProps/constructproplogs.dts";
   footprintSize = "4 6";
   footprintSetRow = "0 0 0 0 0";
   footprintSetRow = "1 0 0 0 0";
   footprintSetRow = "2 0 0 0 0";
   footprintSetRow = "3 0 0 0 0";
   footprintSetRow = "4 0 0 0 0";
   footprintSetRow = "5 0 0 0 0";
	footprintCenter = "2 3";

   // shadow for the object

	receiveLMLighting = false;
	
	detailLevel = $Detail::low;
};
datablock SLGameObjData(constpropschaffold)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/constructpropschaffold.dts";
   footprintSize = "2 6";
   footprintSetRow = "0 0 0";
   footprintSetRow = "1 0 0";
	footprintSetRow = "2 0 0";
   footprintSetRow = "3 0 0";
	footprintSetRow = "4 0 0";
   footprintSetRow = "5 0 0";	
	footprintCenter = "1 3";

   // shadow for the object

	receiveLMLighting = false;
	
	detailLevel = $Detail::low;
};
datablock SLGameObjData(constpropstump)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/constructpropstump.dts";

   //footprint
	footprintSize = "2 2";
	footprintSetRow = "0 1 1";
	footprintSetRow = "1 1 1";
	footprintCenter = "1 1";
	
	receiveLMLighting = false;
	
	maxHealth = 20;
	canDamage = true;
   // shadow for the object

	receiveLMLighting = false;
	
	detailLevel = $Detail::Medium;
};
datablock SLGameObjData(constpropwood)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/constructpropwood.dts";
   footprintSize = "4 4";
   footprintSetRow = "0 1 1 1 1";
   footprintSetRow = "1 1 1 1 1";
   footprintSetRow = "2 1 1 1 1";
   footprintSetRow = "3 1 1 1 1";
	footprintCenter = "2 2";

	receiveLMLighting = false;
	
	maxHealth = 20;
	canDamage = true;
	
	detailLevel = $Detail::Medium;
};
datablock SLGameObjData(destructprop1)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/destructionprop1.dts";
   
   footprintSize = "2 6";
   footprintSetRow = "0 0 0";
   footprintSetRow = "1 0 0";
   footprintSetRow = "2 0 0";
   footprintSetRow = "3 0 0";
   footprintSetRow = "4 1 1";
   footprintSetRow = "5 1 1";
	footprintCenter = "1 3";
   
   maxHealth = 20;
	canDamage = true;
   
   // shadow for the object

	receiveLMLighting = false;
	
};
datablock SLGameObjData(destructprop2)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/destructionprop2.dts";
   
   footprintSize = "2 4";
   footprintSetRow = "0 0 0";
   footprintSetRow = "1 0 0";
   footprintSetRow = "2 0 0";
   footprintSetRow = "3 0 0";
	footprintCenter = "1 2";
   
   maxHealth = 20;
	canDamage = true;
   
   // shadow for the object

	receiveLMLighting = false;
	
};
datablock SLGameObjData(destructprop3)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/destructionprop3.dts";
   
   footprintSize = "6 6";
   footprintSetRow = "0 0 0 0 0 0 0";
   footprintSetRow = "1 1 1 1 1 0 0";
   footprintSetRow = "2 3 3 3 3 1 0";
   footprintSetRow = "3 3 3 3 3 1 0";
   footprintSetRow = "4 3 3 3 3 1 0";
   footprintSetRow = "5 3 3 3 3 1 0";
	footprintCenter = "3 3";
   
   maxHealth = 30;
	canDamage = true;
   
   // shadow for the object

	receiveLMLighting = false;
	
};
datablock SLGameObjData(destructpropwood)
{
   snapGrid = $SnapGrid::Detail;
   //addCmpData = BasePropData;
   
   shapeFile = "~/data/shapes/props/townProps/destructionpropwood.dts";
   footprintSize = "4 4";
   footprintSetRow = "0 0 0 0 0";
   footprintSetRow = "1 0 0 0 0";
   footprintSetRow = "2 0 0 0 0";
   footprintSetRow = "3 0 0 0 0";
	footprintCenter = "2 2";

   // shadow for the object
   maxHealth = 20;
	canDamage = true;
	receiveLMLighting = false;
	
};

//  -------- QUICK JOP PROPS AND PICK UPS ----------

// GOLD VEIN SMALL
datablock CCmpPropData(goldveinsmData)
{
   // random generation of resource pools on initialization
   initGold = true;
   initGoldMin = 100;
   initGoldMax = 125;

   collectTime = 200;
   collectCount = 40;

	workItem = "pickaxe 2 male_and_female";
  workAnimation = "repair";
};

datablock SLGameObjData(goldveinsm)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";
   addCmpData = goldveinsmData;

   shapeFile = "~/data/shapes/props/forestProps/goldveinsm.dts";
   
   //footprint
	footprintSize = "8 8";
	footprintSetRow = "0 3 3 3 3 3 3 3 3";
	footprintSetRow = "1 3 1 1 1 1 1 1 3";
	footprintSetRow = "2 3 1 1 1 1 1 1 3";
	footprintSetRow = "3 3 1 1 1 1 1 1 3";
	footprintSetRow = "4 3 1 1 1 1 1 1 3";
	footprintSetRow = "5 3 1 1 1 1 1 1 3";
	footprintSetRow = "6 3 1 1 1 1 1 1 3";
	footprintSetRow = "7 3 3 3 3 3 3 3 3";
	footprintCenter = "4 4";
	
	// shadow for the object
	receiveLMLighting = false;
	
	canDamage = false;
	
	//effects
	addGameEffect = "special goldsparkleEffectronData 0 2 1.2 " @ $Detail::Low;
	
	sightRange = 4;	
};

datablock CCmpPropData(goldpanData)
{
   // random generation of resource pools on initialization
   initGold = true;
   initGoldMin = 120;
   initGoldMax = 150;

   collectTime = 220;
   collectCount = 45;

	workItem = "Goldpanprop 2 male_and_female";
   workItem = "pannerhat 0 male_and_female";
	workAnimation = "goldpan";
};

datablock SLGameObjData(goldpan)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";
   addCmpData = goldpanData;

   shapeFile = "~/data/shapes/props/forestProps/goldpan.dts";
   
   sightRange = 4;
   //footprint
	footprintSize = "8 8";
	footprintSetRow = "0 3 3 3 3 3 3 3 3";
	footprintSetRow = "1 3 3 3 3 3 3 3 3";
	footprintSetRow = "2 3 3 1 1 1 1 3 3";
	footprintSetRow = "3 3 3 1 1 1 1 3 3";
	footprintSetRow = "4 3 3 1 1 1 1 3 3";
	footprintSetRow = "5 3 3 1 1 1 1 3 3";
	footprintSetRow = "6 3 3 3 3 3 3 3 3";
	footprintSetRow = "7 3 3 3 3 3 3 3 3";
	footprintCenter = "4 4";
	
	// shadow for the object

	receiveLMLighting = false;
	
	canDamage = false;
	
	sightRange = 2;
};

datablock CCmpPropData(FishPropData)
{
   initFood = true;
   initFoodMin = 90;
   initFoodMax = 110;

   collectTime = 250;
   collectCount = 50;
   
   workItem = "fishingpole 2 male_and_female";
   workItem = "fishinghat 0 male_and_female";
   workAnimation = "fish";
};
datablock SLGameObjData(fish)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = FishPropData;
   
	shapeFile = "~/data/shapes/props/forestProps/fish.dts";
	receiveLMLighting = false;

	sightRange = 12;
	
	portraitOffset = "0 .3 0";
	portraitRotation = "150";
	portraitHeight = "1.2";
	portraitZoom = "130";
	portraitAngle = "15";
	portraitFOV = "2";
	
	canDamage = false;
	
	deathFade = 1;
};
function fish::onAdd(%this,%obj)
{
  %obj.playThread(0, "ambient");
}

//quickjog log: wood
datablock CCmpPropData(LogwoodPropData)
{
   // random generation of resource pools on initialization
   initWood = true;
   initWoodMin = 55;
   initWoodMax = 65;

   collectTime = 120;
   collectCount = 30;

	workItem = "Axe 2 male_and_female";
  workAnimation = "repair";
};
datablock SLGameObjData(log)
{
  addCmpData = LogwoodPropData;
  snapGrid = $SnapGrid::Detail;
	shapeFile = "~/data/shapes/props/forestProps/log.dts";
   
   // shadow for the object
	receiveLMLighting = false;
	
	//footprint
	footprintSize = "2 4";
	footprintSetRow = "0 0 0";
	footprintSetRow = "1 0 0";
	footprintSetRow = "2 0 0";
	footprintSetRow = "3 0 0";
	footprintCenter = "1 2";
	
	sightRange = 3;
};

// Treasure Chest
datablock CCmpPropData(ChestPropData)
{
   initGold = true;
   initGoldMin = 120;
   initGoldMax = 200;

   collectTime = 0;
   collectCount = 1;

   sightRange = 2;
};
datablock SLGameObjData(chest)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = chestPropData;
   
	shapeFile = "~/data/shapes/props/townProps/chest.dts";
	receiveLMLighting = false;
	canDamage = false;
	deathAnimation = "pickup";      // prop's dying animation
   deathWait = 1;
   
   sightRange = 2;
};
// Gold Sack Pickup
datablock CCmpPropData(GoldbagpickupPropData)
{
   initGold = true;
   initGoldMin = 5;
   initGoldMax = 10;

   collectTime = 0;
   collectCount = 1;
};
datablock SLGameObjData(goldbagpickup)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = goldbagpickupPropData;
   
	shapeFile = "~/data/shapes/props/townProps/goldbagpickup.dts";
	receiveLMLighting = false;
	
	canDamage = false;
	deathAnimation = "pickup";  // prop's dying animation
   deathWait = 1;
   
   sightRange = 1;
};

// Money Bag Pickup
datablock CCmpPropData(MoneybagpickupPropData)
{
   initGold = true;
   initGoldMin = 5;
   initGoldMax = 15;

   collectTime = 0;
   collectCount = 1;
};
datablock SLGameObjData(moneybagpickup)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = goldbagpickupPropData;
   
	shapeFile = "~/data/shapes/props/moneybagpickup.dts";
	receiveLMLighting = false;
   canDamage = false;
	deathAnimation = "pickup";      // prop's dying animation
   deathWait = 1;
   
   sightRange = 1;
};
// Wood pile
datablock CCmpPropData(woodPropData)
{
   initWood = true;
   initWoodMin = 20;
   initWoodMax = 25;

   collectTime = 0;
   collectCount = 1;
};
datablock SLGameObjData(woodpickup)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = woodPropData;
   
	shapeFile = "~/data/shapes/props/townProps/woodpickup.dts";
	receiveLMLighting = false;
	canDamage = false;
	deathAnimation = "pickup";      // prop's dying animation
   deathWait = 1.6;
   
   sightRange = 2;
};
// Apple Basket
datablock CCmpPropData(foodPropData)
{
   initFood = true;
   initFoodMin = 5;
   initFoodMax = 7;

   collectTime = 0;
   collectCount = 1;
};
datablock SLGameObjData(applebasket)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = foodPropData;

   shapeFile = "~/data/shapes/props/townProps/applebasket.dts";
   
   //footprint
	footprintSize = "1 1";
	footprintSetRow = "0 0";
	footprintCenter = "0.5 0.5";

	// shadow for the object

	receiveLMLighting = false;
	
	deathAnimation = "pickup";     // prop's dying animation
   deathWait = 0.5;
   canDamage = false;
   sightRange = 2;
};

datablock SLGameObjData(meatpickup)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = foodPropData;

   shapeFile = "~/data/shapes/props/townProps/meatpickup.dts";
   
   //footprint
	footprintSize = "1 1";
	footprintSetRow = "0 0";
	footprintCenter = "0.5 0.5";

	// shadow for the object

	receiveLMLighting = false;
	
	deathAnimation = "pickup";     // prop's dying animation
   deathWait = 0.5;
   canDamage = false;
   sightRange = 2;
};

datablock SLGameObjData(Berrybush)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = foodPropData;
   
   shapeFile = "~/data/shapes/props/forestProps/berrybush.dts";    

	
	//footprint
	footprintSize = "2 2";
	footprintSetRow = "0 2 2";
	footprintSetRow = "1 2 2";
	footprintCenter = "1 1";

	buildOver = false;
	
	//effects
	addGameEffect = "timber leafEffectronData 0 0 5.2 " @ $Detail::Medium;  //pickup effect
	
	deathEffectTimber = true;
   deathAnimation = "pickup"; // prop's dying animation
   deathWait = 0.5;
   canDamage = false;
   receiveLMLighting = false;
   
   sightRange = 2;
};

// Crate pickup

datablock CCmpPropData(crateWoodPropData)
{
   initWood = true;
   initWoodMin = 5;
   initWoodMax = 10;

   collectTime = 0;
   collectCount = 1;
};
datablock CCmpPropData(crateFoodPropData)
{
   initFood = true;
   initFoodMin = 4;
   initFoodMax = 8;

   collectTime = 0;
   collectCount = 1;
};
datablock CCmpPropData(crateGoldPropData)
{
   initGold = true;
   initGoldMin = 10;
   initGoldMax = 20;

   collectTime = 0;
   collectCount = 1;
};
datablock SLGameObjData(cratepickup)
{
   snapGrid = $SnapGrid::Detail;
   addCmpData = crateWoodPropData;
   shapeFile = "~/data/shapes/props/townProps/crate.dts";
   receiveLMLighting = false;
   deathAnimation = "pickup"; // prop's dying animation
   deathWait = 1.6;
   canDamage = false;
   
   portraitOffset = "0 0 0";
	portraitRotation = "25";
	portraitHeight = "1.4";
	portraitZoom = "18";
	portraitAngle = "5";
	portraitFOV = "9";
   
   sightRange = 2;
};

function crateWoodPropData::onAdd(%datablock, %object)
{
   %random = getRandom(0, 2);
   switch (%random)
   {
      case 0: %object.setDataBlock(crateWoodPropData);
      case 1: %object.setDataBlock(crateFoodPropData);
      case 2: %object.setDataBlock(crateGoldPropData);
   }
}

// ------------ Road and Track -------------
datablock SLGameObjData(tracklong)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/longtrack.dts";
   
   //footprint
	footprintSize = "12 4";
	footprintSetRow = "0 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "6 2";

	// shadow for the object
	receiveLMLighting = true;
	canDamage = false;
	
	//Track info
	isTrack = true;
	addHotSpot = "0 2 0";
};
datablock SLGameObjData(trackup)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/uptrack.dts";
   
   //footprint
	footprintSize = "16 6";
	footprintSetRow = "0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "8 3";

	// shadow for the object
	receiveLMLighting = true;
	canDamage = false;
	
	//Track info
	isTrack = true;
	addHotSpot = "0 5 -14.036";
};
datablock SLGameObjData(trackdown)
{
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

   shapeFile = "~/data/shapes/props/townProps/downtrack.dts";
   
   //footprint
	footprintSize = "16 6";
	footprintSetRow = "0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "3 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "5 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "8 3";

	// shadow for the object
	receiveLMLighting = true;
	canDamage = false;
	
	//Track info
	isTrack = true;
	addHotSpot = "0 2 14.035";
};
// Effect Arrow
datablock SLGameObjData(arrow)
{
   snapGrid = $SnapGrid::Detail;

	shapeFile = "~/data/shapes/effects/arrow.dts";
	receiveLMLighting = false;

};
function arrow::onAdd(%this,%obj)
{
  %obj.playThread(0, "ambient");
}
datablock SLGameObjData(waterfall)
{
   snapGrid = $SnapGrid::Detail;

   shapeFile = "~/data/shapes/buildings/minewater.dts";
	receiveLMLighting = false;
};
